/** Contains static recursive methods used in this livetext */
public class Recursion {
         
   /** = p, but with blanks removed */
   public static String deblank(String p) {
      if (p.length() == 0)
         return p;
      if (p.charAt(0) == ' ')
         return deblank(p.substring(1));
      return p.charAt(0) + deblank(p.substring(1));
   }
   
   /** Given y >= 0, return x**y */
   public static int exp(int x, int y) {
      if (y == 0)
         return 1;
      if (y%2 == 0)
         return exp(x*x, y/2);
      return x*exp(x, y-1);
   }
   
   /** = n!  (assuming n >= 0) */
   public static int factorial(int n) {
      if (n == 0)
         return 1;
      return n * factorial(n-1);
   } 
   
   /** Set elements of b[h..k] to 0 */
   public static void setToZero(int[] b, int h, int k) {
      if (h == k+1)
         return;
      b[h]= 0;
      setToZero(b, h+1, k);
      }
      
   /** Tile the 2**n by 2**n rectangle with upper left corner
       (x,y). One particular square foot of it is already covered.
       This version of the algorithm is abstract and won't work, in
       the sense that the one-foot covered square is not indicated. */
   public static void tile(int n, int x, int y) {
      if (n == 0)
         return;
      // Place a tile so each quadrant has a square covered;
      int e= exp(2, y-1);   // e = 2**(y-1)
      tile(n-1, x, y);
      tile(n-1, x+e, y);
      tile(n-1, x, y+e);
      tile(n-1, x+e, y+e);
   }
}
